import sys
import pygame
import pygame.camera

pygame.init()
pygame.camera.init()

#wyświetl obraz o rozdzielczości 640x480 w trybie pełnoekranowym
screen = pygame.display.set_mode((640,480),0)

#znajdź, otwórz i uruchom kamerę o niskiej rozdzielczości
cam_list = pygame.camera.list_cameras()
webcam = pygame.camera.Camera(cam_list[0],(320,240))
webcam.start()

while True:
    #przechwyć obraz, a następnie go przeskaluj i wyświetl
    imagen = webcam.get_image()
    imagen = pygame.transform.scale(imagen,(640,480))
    screen.blit(imagen,(0,0))
    
    #wyswietlaj wszystkie aktualizacje
    pygame.display.update()
    
    # sprawdź wystąpienie zdarzenia zamykającego program
    for event in pygame.event.get():
        if event.type == pygame.QUIT:
            webcam.stop()
            pygame.quit()
            sys.exit()
